package w83b.w83bOperacionesInternas.w83bLotesPreavisos;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;

import w83b.w83bBeans.W83bLotesPreavisosBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bBeans.W83bDocumentoBean;
import w83b.w83bUtilidadesComunes.W83bClsTrazas;
import w83b.w83bUtilidadesComunes.W83bSolicitudPreaviso;
//import w83b.w83bUtilidadesComunes.w83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bUtilidadesN38API;

import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInterna;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaConfigBean;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaError;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors;

import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

public class W83bLotesPreavisosAnyadirOIAction extends Q70OperacionInterna{
	/**
	 * preProcessMappingEntrada
	 * @param contexto a
	 * @param configBean a
	 * @param errors a
	 * @throws Exception e
	 */				
	protected void preProcessMappingEntrada(Q70ContextoEJIE contexto, Q70OperacionInternaConfigBean configBean, Q70OperacionInternaErrors errors) throws Exception{				
		
				
		if (contexto.get("w83bMapaFilePreavisos")!=null){
			W83bLotesPreavisosBean lote = (W83bLotesPreavisosBean)contexto.get("w83bPreavisosNuevoBean");

			W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get("w83bUsuarioXLNets");
			usuario.setIdioma((String)contexto.get("w83bCgaIdioma"));
			lote.setCodPromotor("");
			HashMap mapaFiles =(HashMap)contexto.get("w83bMapaFilePreavisos");
			Iterator iter = mapaFiles.keySet().iterator();
			W83bDocumentoBean docBean=null;
			
			W83bClsTrazas.trazaError(null, "en el OI (usuario.getPerfilXLNets()): " + usuario.getPerfilXLNets(), null);
			
			
			
			
			String territorio = W83bUtilidadesN38API.elegirProvinciaDelegacion(usuario.getPerfilXLNets());

			W83bClsTrazas.trazaError(null, "en el OI (territorio): " +territorio, null);
			
			while (iter.hasNext())
			{
				HashMap datosFile=(HashMap)mapaFiles.get(iter.next());
				docBean= new W83bDocumentoBean();//NOPMD
				docBean.setNombre((String)datosFile.get("nombreDocumento"));
				contexto.set("nombreFichero", (String)datosFile.get("nombreDocumento"));
				docBean.setUsuario(usuario);
				
				
				
				InputStream i = (InputStream)datosFile.get("documentoStream");
				//byte[] temporal = (byte[])docBean.getFileData().;
			
		
				
				
				//pasamos a un string el contenido del fichero para poder mostrar
				byte[] bytes = new byte[1024*1024*2];//NOPMD
				int leido = 0;
			    ByteArrayOutputStream b = new ByteArrayOutputStream();//NOPMD
			    while ((leido = i.read(bytes)) != -1)
			        b.write(bytes,0,leido);
			    byte[] b2 = b.toByteArray();
		
			    InputStream is1 = new ByteArrayInputStream(b2);//NOPMD
			    InputStream is2 = new ByteArrayInputStream(b2);//NOPMD
			    InputStream is3 = new ByteArrayInputStream(b2);//NOPMD
				  
			    String caracter = new String(b2, "ISO-8859-1");//NOPMD
				contexto.set("documentoImportadoOriginal", caracter);
			    
			    
			    
			    docBean.setFileData(is2);
				docBean.setTamanyo(((Long)datosFile.get("tamanyo")).intValue());
				lote.getListaDocs().add(docBean);
				
				
				
				W83bSolicitudPreaviso documento = new W83bSolicitudPreaviso();//NOPMD
				//documento.extraerInformacion(caracter, contexto.get(w83bClsConstantes.XLNETS_PERSONTYPE).toString(), territorio);
				documento.extraerInformacion(caracter, territorio);
				
				//String tesxtoPlano = documento.getTxtPlano(usuario.getIdioma());
				W83bClsTrazas.trazaError(null, "documento getSindicato: " +documento.getSindicato(), null);
				W83bClsTrazas.trazaError(null, "documento getTerritorioCabecera: " +documento.getTerritorioCabecera(), null);
				contexto.set("solicitudPreaviso", documento);

			}
			lote.setListaDocs2(lote.getListaDocs());
		}
		super.preProcessMappingEntrada(contexto, configBean, errors);
			
	}
	
	/**
	 * postProcessMappingSalida
	 * @param contexto a
	 * @param errors a
	 * @throws Exception e
	 */
	protected void postProcessMappingSalida(Q70ContextoEJIE contexto, Q70OperacionInternaErrors errors) throws Exception {

		HashMap resultado = (HashMap)contexto.get("w83bResultadoMapa");
		
		
		contexto.set("w83bResultadoMapa",resultado);
		
	
		contexto.set("codSelec",(String)resultado.get("codSelec"));
		contexto.set("errorFichero",(String)resultado.get("error"));
		
		
		
		
		super.postProcessMappingSalida(contexto, errors);
	}
	
	protected void processOIException(Q70ContextoEJIE paramQ70ContextoEJIE, Exception paramException, Q70OperacionInternaErrors paramQ70OperacionInternaErrors)
	throws Exception{
		/*if(null!=paramException&&null!=((Q70OperacionInternaException)paramException).getPrimaryException() && ((Q70OperacionInternaException)paramException).getPrimaryException() instanceof w83bLibroRegistroExceptio){
			paramQ70OperacionInternaErrors.add("OI_ERROR", new Q70OperacionInternaError("error.mensaje.errorRegistroEntrada"));
		}else{*/
			paramQ70OperacionInternaErrors.add("OI_ERROR", new Q70OperacionInternaError(getConfiguracion().getOiErrorKey()));			
		//}
	}
}